USE [SUPERMERCADO]
-- ================================================
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- AUTOR: ERICK MARTINEZ
-- FECHA DE CREACION: 10/06/2015
-- DESCRIPCION: CALCULA EL PRODUCTO CON IMPUESTO Y DESCUENTO
-- =============================================
CREATE FUNCTION [dbo].[TOTAL_PAGAR_PRODUCTO]
(
	@ID_PRODUCTO INT,
	@IMPUESTO FLOAT, -- EN BASE A PORCENTAJE
	@DESCUENTO FLOAT -- EN BASE A PORCENTAJE		
)
RETURNS FLOAT
AS
BEGIN
	
	DECLARE @TOTAL FLOAT
	DECLARE @PRODUCTO_VENTA FLOAT


	SELECT 
		@PRODUCTO_VENTA = 
			[SUPERMERCADO].[dbo].[PRODUCTO].[VENTA_PRODUCTO] 
			
	FROM
		[SUPERMERCADO].[dbo].[PRODUCTO]

	WHERE 
		@ID_PRODUCTO = [SUPERMERCADO].[dbo].[PRODUCTO].[ID_PRODUCTO]


	SET @TOTAL = 
				@PRODUCTO_VENTA + 
				(@PRODUCTO_VENTA * @IMPUESTO) /100 -
				(@PRODUCTO_VENTA * @DESCUENTO)/100

	RETURN @TOTAL

END
GO

